/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

#ifndef ORBMATCHDESCRIPTORSKERNELLIST_H
#define ORBMATCHDESCRIPTORSKERNELLIST_H

#include "match_descriptors_acf.h"

KERNEL_INFO kernelInfoConcat(MATCH_DESCRIPTORS_K)
(
  MATCH_DESCRIPTORS_KN,
  5,
  __port(__index(0),
         __identifier(MATCH_DESCR_KN_IN0),
         __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
         __spatial_dep(0,0,0,0),
         __e0_data_type(d08u),
         __e0_size(1, 1),
         __ek_size(1, 1)),
  __port(__index(1),
         __identifier(MATCH_DESCR_KN_IN1),
         __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
         __spatial_dep(0,0,0,0),
         __e0_data_type(d08u),
         __e0_size(1, 1),
         __ek_size(1, 1)),
  __port(__index(2),
         __identifier(MATCH_DESCR_KN_CFG),
         __attributes(ATTR_IN|ATTR_DMEM|ATTR_STATIC|ATTR_FIXED|ATTR_REG),
         __spatial_dep(0,0,0,0),
         __e0_data_type(d16u),
         __e0_size(1, 1),
         __ek_size(4, 1)),
  __port(__index(3),
         __identifier(MATCH_DESCR_KN_OUT0),
         __attributes(ATTR_OUT|ATTR_DMEM|ATTR_STATIC|ATTR_FIXED|ATTR_REG),
         __spatial_dep(0,0,0,0),
         __e0_data_type(d16s),
         __e0_size(1, 1),
         __ek_size(512, 1)),
  __port(__index(4),
         __identifier(MATCH_DESCR_KN_OUT1),
         __attributes(ATTR_OUT|ATTR_DMEM|ATTR_STATIC|ATTR_FIXED|ATTR_REG),
         __spatial_dep(0,0,0,0),
         __e0_data_type(d16s),
         __e0_size(1, 1),
         __ek_size(512, 1))
);

#endif /* ORBMATCHDESCRIPTORSKERNELLIST_H */
